﻿<%@ import Namespace="Soneta.CRM" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Business" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Raport sprzeday wg kontrahentow</title>
		<script runat="server">
		
public enum SortowanieWedług { WgKoduKontrahenta, WgNazwyKontrahenta, WgWartościMalejąco }

public class ParametryContext : ContextBase { 
	public ParametryContext(Context cx) : base(cx) {
	}

	SortowanieWedług sortujWedług = SortowanieWedług.WgNazwyKontrahenta;

	[DefaultWidth(50)]
	[Priority(10)]
	public SortowanieWedług SortujWedług {
		get { return sortujWedług; }
		set { 
			sortujWedług = value; 
			OnChanged(EventArgs.Empty);
		}
	}
	
	int pierwszych = 0;
	
	[Priority(20)]
	public int Pierwszych {
		get { return pierwszych; }
		set { pierwszych = value; }
	}
	
	public bool IsReadOnlyPierwszych() {
		return SortujWedług!=SortowanieWedług.WgWartościMalejąco;
	}

	private bool _ignorujZaliczkowe = true;

	[Soneta.Tools.Priority(30)]
	public bool IgnorujZaliczkowe
	{
		get
		{
			return this._ignorujZaliczkowe;
		}
		set
		{
			this._ignorujZaliczkowe = value;
			OnChanged(EventArgs.Empty);
		}
	}

}

ParametryContext parametry;

[Context]
public ParametryContext Parametry {
	get { return parametry; }
	set { parametry = value; }
}

public class Total {
    readonly Kontrahent kontrahent;
    decimal netto;
    decimal vat;
    decimal brutto;
    public Total(Kontrahent kontrahent) {
        this.kontrahent = kontrahent;
    }
    public void Add(DokumentHandlowy dokument) {
        netto += dokument.Suma.Netto;
        vat += dokument.Suma.VAT;
        brutto += dokument.Suma.Brutto;
    }
    public Kontrahent Kontrahent {
        get { return kontrahent; }
    }
    public decimal Netto {
        get { return netto; }
    }
    public decimal VAT {
        get { return vat; }
    }
    public decimal Brutto {
        get { return brutto; }
    }
}

class NazwaComparer : IComparer {
    public int Compare(object obj1, object obj2) {
        Total t1 = (Total)obj1;
        Total t2 = (Total)obj2;
        string s1 = t1.Kontrahent == null ? "" : t1.Kontrahent.Nazwa;
        string s2 = t2.Kontrahent == null ? "" : t2.Kontrahent.Nazwa;
        return s1.CompareTo(s2);
    }
}

class KodComparer : IComparer {
    public int Compare(object obj1, object obj2) {
        Total t1 = (Total)obj1;
        Total t2 = (Total)obj2;
        string s1 = t1.Kontrahent == null ? "" : t1.Kontrahent.Kod;
        string s2 = t2.Kontrahent == null ? "" : t2.Kontrahent.Kod;
        return s1.CompareTo(s2);
    }
}

class WartośćComparer : IComparer {
    public int Compare(object obj1, object obj2) {
        Total t1 = (Total)obj1;
        Total t2 = (Total)obj2;
        if (t1.Netto<t2.Netto) return 1;
        if (t1.Netto>t2.Netto) return -1;
        return 0;
    }
}

void OnContextLoad(Object sender, EventArgs args) {
    Soneta.Handel.Forms.DokHandloweViewInfo.WParams pars = (Soneta.Handel.Forms.DokHandloweViewInfo.WParams)dc[typeof(Soneta.Handel.Forms.DokHandloweViewInfo.WParams)];
    if (pars.Kategoria == KategoriaHandlowa.Sprzedaż) {
        string t = string.Format("Raport sprzedaży wg kontrahentów|</STRONG>Magazyn:<STRONG> {0}", pars.Magazyn);
        ReportHeader.Title = t;
    }
    else if (pars.Kategoria == KategoriaHandlowa.Zakup) {
        string t = string.Format("Raport zakupów wg kontrahentów|</STRONG>Magazyn:<STRONG> {0}", pars.Magazyn);
        ReportHeader.Title = t;
    }
    else if (pars.Kategoria == KategoriaHandlowa.WydanieMagazynowe) {
        string t = string.Format("Raport wydań wg kontrahentów|</STRONG>Magazyn:<STRONG> {0}", pars.Magazyn);
        ReportHeader.Title = t;
    }
    else if (pars.Kategoria == KategoriaHandlowa.PrzyjęcieMagazynowe) {
        string t = string.Format("Raport przyjęć wg kontrahentów|</STRONG>Magazyn:<STRONG> {0}", pars.Magazyn);
        ReportHeader.Title = t;
    }    
    if (pars.Kontrahent!=null)
        ReportHeader.Title += string.Format("|</STRONG>Kontrahent<STRONG>: {0}", pars.Kontrahent.ToString());
    if (pars.Definicja!=null)
        ReportHeader.Title += string.Format("|</STRONG>Definicja:<STRONG> {0}", pars.Definicja.ToString());
    if (pars.Okres!=Soneta.Types.FromTo.All)
        ReportHeader.Title += string.Format("|</STRONG>Okres:<STRONG> {0}", pars.Okres.ToString());

    Row[] rows = (Row[])dc[typeof(Row[])];
    Hashtable result = new Hashtable();
    foreach (DokumentHandlowy dokument in rows) {
		if (dokument.Anulowany) continue; 
		if (Parametry.IgnorujZaliczkowe && dokument.Definicja.EdycjaWartosci == EdycjaWartosciDokumentu.PozwalajNaMniejsząKwotę) continue; 
        if (dokument.Definicja.DuplikatWartosci) continue;
        if (dokument.Kontrahent==null) continue;
        Total t = (Total)result[dokument.Kontrahent];
        if (t==null) {
            t = new Total(dokument.Kontrahent);
            result.Add(t.Kontrahent, t);
        }
        t.Add(dokument);
    }

    ArrayList lista = new ArrayList(result.Values);
    switch (Parametry.SortujWedług) {
		case SortowanieWedług.WgKoduKontrahenta:
			lista.Sort(new KodComparer());
			break;
		case SortowanieWedług.WgNazwyKontrahenta:
			lista.Sort(new NazwaComparer());
			break;
		case SortowanieWedług.WgWartościMalejąco:
			lista.Sort(new WartośćComparer());
			if (Parametry.Pierwszych>0 && lista.Count>Parametry.Pierwszych)
				lista.RemoveRange(Parametry.Pierwszych, lista.Count-Parametry.Pierwszych);
			break;
	}
    Grid.DataSource = lista;
}

		</script>
		<meta content="C#" name="CODE_LANGUAGE" />
		<meta content="JavaScript" name="vs_defaultClientScript" />
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
	</head>
	<body>
		<form method="post" runat="server" action="#">
			<ea:DataContext id="dc" runat="server" oncontextload="OnContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" title="Raport sprzedaży wg kontrahentów" runat="server"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="18" Align="Left" DataMember="Kontrahent.Kod" Caption="Kod" NoWrap="True" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="48" DataMember="Kontrahent.Nazwa" Caption="Kontrahent" NoWrap="True" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Netto" Total="Sum" Format="{0:n}" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="VAT" Total="Sum" Format="{0:n}" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Brutto" Total="Sum" Format="{0:n}" runat="server"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
		</form>
	</body>
</html>

